%{
#include <stdio.h>
#include <stdlib.h>

int yylex(void);
void yyerror(const char *s) {
    fprintf(stderr, "Error: %s\n", s);
}

extern FILE *yyin;
%}

%token NUMBER

%%

input:
      /* empty */
    | input expr terminator   { printf("= %d\n", $2); }
    | input expr              { printf("= %d\n", $2); }
    ;

terminator:
      '\n'
    | '\r'
    ;

expr:
      NUMBER
    | expr '+' expr   { $$ = $1 + $3; }
    | expr '*' expr   { $$ = $1 * $3; }
    | '(' expr ')'    { $$ = $2; }
    ;

%%

int main(int argc, char **argv) {

    if (argc > 1) {
        FILE *f = fopen(argv[1], "r");
        if (!f) {
            perror("Cannot open file");
            return 1;
        }
        yyin = f;
    }

    return yyparse();
}